// File: applib.h
//
// Description: Header file for the Microsoft Windows NT
//              class library.
//
// Copyright 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library
//       may be used in compiled form without restrictions.
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//

#ifndef __applib
#define __applib


#include <windows.h>

#include <stdlib.h>
#include <string.h>
//#include <fstream.h>
#include <iostream.h>
#include <fstream.h>

extern "C" { void sprintf(...); void exit(int); };

LONG APIENTRY WndProc(HWND hWnd,
              UINT iMessage,
              UINT wParam,
                      LONG lParam );
                                 
#define output (ios::out)
#define input (ios::in)

class TAppWindow;

class Application
{
 public:
    // Class static variables for Windows interface:
    static HANDLE instanceHandle;
    static HANDLE applicationRegisteredFlag;
    static int showWindowFlag;
    static int processEventMessages( void );

    enum {DIALOG_TEXT_LENGTH=128, DIALOG_MAX_LIST_ITEMS=64};

    // class public member functions are visible to all
    // C functions in our program:
    static TAppWindow * get_TAppWindow()
    { return app_window; }
    static void set_TAppWindow(TAppWindow *aw)
    { app_window = aw; }

    // Class public variables for holding the result of
    // Dialog box functions:
    static CHAR text_from_dialog[DIALOG_TEXT_LENGTH];
    static int selection_from_dialog;
    static CHAR prompt_for_dialog[DIALOG_TEXT_LENGTH];
    static CHAR file_extension_for_dialog[DIALOG_TEXT_LENGTH];
    static CHAR * list_items_for_dialog[DIALOG_MAX_LIST_ITEMS];
    static int number_of_dialog_list_items;

 private:
    // All instances of this class share the following, so
    // only create one instance of an Application object
    // in your programs.  Use the following in the 'C'
    // language window callback function to access our
    // C++ Application object and C++ TAppWindow object:
    static TAppWindow * app_window;

};

const int MAX_TEXT_LINES = 24;
const int MAX_TEXT_LINE_SIZE = 80;

class TAppWindow
{
 protected:
    HWND hWnd;
 private:
    static char windowName[20];
    HBRUSH backgroundBrush;
    HBRUSH blackBrush;
    // Data for supporting scrolling text:
    int top_text_clip, right_text_clip;
    int bottom_text_clip, left_text_clip;
    char *saved_text[MAX_TEXT_LINES]; // ring buffer for
                                      // saved text
    int number_of_saved_lines;
    int current_ring_buffer_start;
    int in_scrolling_text_mode; // =1 for in text mode
    int redraw_both_text_and_graphics;
    BOOL Show( int showWindowFlag )
    { return ShowWindow( hWnd, showWindowFlag ); };
    void Update( void ) { UpdateWindow( hWnd ); };

 public:

    TAppWindow( void );

    static void registerWindow( void );
    HWND GetHandle( void ) { return hWnd; };

    void plot_line(int x1, int y1, int x2, int y2);
    void plot_string(int x, int y, char *cp);
    void plot_rect(int top, int right, int bottom, int left);
    void erase_rect(int top, int right, int bottom, int left);
    int string_height(char *)
      {
         return 13;
      }
    int string_width(char *str)
      {
          return 9 * strlen(str);
      }

    void clear_display();
    void redraw_display();
    

    long WndProc(UINT iMessage,
                 WPARAM wParam,
                 LPARAM lParam);
    void Paint(void);
    // Maintain a valid HDC only during paint operations:
    HDC current_hDC;

    // user defined callback(s):
    void update_display();
    void mouse_down(int, int );
    void mouse_up(int, int );
    void mouse_move(int, int );
    void do_menu_action(int);

    // for the About box:
    void do_about();
    void do_edit(char *prompt, char *str);
    void show_info(char *str) { do_edit(" ", str); }
    int choose_one_from_list(char *prompt,
                             char **list_items,
                             int number_of_items);
    int choose_one(char *prompt1, char *prompt2);
    int choose_file_to_write(char *prompt,
                             char *returned_filename);
    int choose_file_to_read(char *prompt,
                            char *extension,
                            char *returned_filename);

    void init_scrolling_text(int top, int right,
                             int bottom, int left);
    void init_scrolling_text();
    void put_scrolling_text(char *str);
    void reset_scrolling_text();
    void idle_proc();
};

void Warning(char *);

#define INIT_PROGRAM(menu_name, \
                     number_menu_items, \
                     menu_items) \
int n_m_items;   \
char ** m_items; \
char *m_name;    \
                        \
void private_setup() {  \
    n_m_items = number_menu_items;         \
    m_items   = menu_items;                \
    m_name    = menu_name;                 \

#define RUN_PROGRAM 


#endif __applib
